package jcircus.environment;

import java.util.Hashtable;

/**
 * ChannelEnv.java
 *
 * @author Angela Freitas
 */
public class ChannelEnv {
    
    /**
     * String (processName) -> ProcChanEnv
     *
     * Maps the process name into his channel environment.
     *
     */
    private Hashtable channelEnvironment;
    
    /**
     * Constructor
     *
     */
    public ChannelEnv() {
        this.channelEnvironment = new Hashtable();
    }
    
    /**
     * 
     * @param processName
     * @param procChanEnv
     */
    public void put(String processName, ProcChanEnv procChanEnv) {
        this.channelEnvironment.put(processName, procChanEnv);
    }
    
    /**
     *
     * @param string
     * @return
     */
    public ProcChanEnv get(String string) {
        return (ProcChanEnv) this.channelEnvironment.get(string);
    }
    
}
